package com.agilex.healthcare.veteranappointment.dataservice;

import java.util.Date;

import javax.annotation.Resource;
import javax.ws.rs.WebApplicationException;

import com.agilex.healthcare.veteranappointment.datalayer.patient.PatientMetadataDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientMetadata;
import com.agilex.healthcare.mobilehealthplatform.serviceregistry.ScopeFilter;
import org.springframework.stereotype.Service;

@Service
public class PatientMetadataDataService {
	
	@Resource
	private PatientMetadataDataLayer patientMetadataDataLayer;
	
	public PatientMetadata getPatientMetadataByPatientId(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		return patientMetadataDataLayer.fetchPatientMetadataByPatientId(patientIdentifier.getUniqueId());
	}

	public PatientMetadata savePatientMetadata(PatientMetadata patientMetadata, ScopeFilter scopeFilter) {
		return patientMetadataDataLayer.savePatientMetadata(patientMetadata);
	}
	
	public Date fetchAndUpdateLastAccessDate(PatientIdentifier patientIdentifier, ScopeFilter scopeFilter) {
		Date lastAppointmentRequestAccessDate = null;
		
		PatientMetadata patientMetadata;
		
		try {
			patientMetadata = getPatientMetadataByPatientId(patientIdentifier, scopeFilter);
			lastAppointmentRequestAccessDate = new Date(patientMetadata.getLastAppointmentRequestAccessDate().getTime());
		} catch (WebApplicationException e) {
			Date now = new Date();
			lastAppointmentRequestAccessDate = now;
			patientMetadata = new PatientMetadata();
			patientMetadata.setPatientIdentifier(patientIdentifier);
			patientMetadata.setLastAppointmentRequestAccessDate(now);
		}
		
		updateLastAccessDate(patientMetadata, scopeFilter);
		
		return lastAppointmentRequestAccessDate; 
	}
	
	private void updateLastAccessDate(PatientMetadata patientMetadata, ScopeFilter scopeFilter) {
		patientMetadata.setLastAppointmentRequestAccessDate(new Date());
		savePatientMetadata(patientMetadata, scopeFilter);
	}
}
